//
//  OnePasswordWiFiSyncConstants.h
//  ApplicationFrameworks
//
//  Created by Roustem Karimov on 2014-09-01.
//
//

#import <Foundation/Foundation.h>

FOUNDATION_EXPORT int32_t OPWiFiSyncVersion_1;
FOUNDATION_EXPORT int32_t OPWiFiSyncCurrentVersion;

FOUNDATION_EXPORT NSString *OPWiFiSyncRequestAuth;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestHandshake;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestBeginSync;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestSync;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestBeginSyncAttachments;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestSyncAttachments;
FOUNDATION_EXPORT NSString *OPWiFiSyncRequestEndSync;


FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadVersionKey;

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadCapabilitiesKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncCapabilityAttachments;
FOUNDATION_EXPORT NSString *OPWiFiSyncCapabilityMultipleVaults;
FOUNDATION_EXPORT NSString *OPWiFiSyncCapabilityStableMasterKeyForUUID; // [rfillion 2014-12-17] Indicates that for each sync of a profile of UUID x, the provided profile master key will not be different. Windows currently passes different keys for the same UUID, making our key dance unlocking invalid.
FOUNDATION_EXPORT NSString * const OPWiFiSyncCapabilityErrorJSON; // [rfillion 2016-05-27] Indicates that errors can be returned not just as a context-less string, but instead as base64 encoded JSON dictionaries with OPWiFiSyncError*Key keys

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadRequestKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadProfileUUIDKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadTimestampKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadSessionUUIDKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadProfileKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadSecondaryProfilesKey;

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadItemTimestampsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadFolderTimestampsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadItemAttachmentTimestampsKey;

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadItemsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadFoldersKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadAttachmentsKey;

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadRequestedItemsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadRequestedFoldersKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadRequestedAttachmentsKey;

FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadUpdatedItemTimestampsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadUpdatedFolderTimestampsKey;
FOUNDATION_EXPORT NSString *OPWiFiSyncPayloadUpdatedAttachmentTimestampsKey;

FOUNDATION_EXPORT NSString * const OPWiFiSyncErrorDomain; // for use if creating NSErrors out of code/messages

// OPWiFiSyncError*Key Dictionary Keys
FOUNDATION_EXPORT NSString * const OPWiFiSyncErrorCodeKey; // Number (OPWiFiSyncErrorCode)
FOUNDATION_EXPORT NSString * const OPWiFiSyncErrorMessageKey; // String

// Error Codes
// Append only, as these values need to match clients across different versions.
typedef NS_ENUM(NSUInteger, OPWiFiSyncErrorCode) {
	OPWiFiSyncErrorCodeUnknown = 0,
	OPWiFiSyncErrorCodeMessageDecryptionFailed = 1, // Message sent to server was failed to be decrypted
	OPWiFiSyncErrorCodeInvalidPayload = 2, // Message was not found to be JSON, or payload failed to validate
	OPWiFiSyncErrorCodeInvalidRequest = 3, // Server couldn't make sense of the request.
	OPWiFiSyncErrorCodeRateLimitExceeded = 4,
	OPWiFiSyncErrorCodeNoPrimaryVault = 5, // Server has no primary vault with which to sync
	OPWiFiSyncErrorCodeProfileLocked = 6, // Vault to sync with is locked
	OPWiFiSyncErrorCodeInvalidProfile = 7, // The vault sent to the server with which to sync has no corresponding vault on the server.
	
};